/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.item.enderbook;

import com.lothrazar.cyclic.data.BlockPosDim;
import com.lothrazar.cyclic.item.ItemBaseCyclic;
import com.lothrazar.cyclic.item.datacard.LocationGpsCard;
import com.lothrazar.cyclic.item.enderbook.CapabilityProviderEnderBook;
import com.lothrazar.cyclic.item.enderbook.ContainerProviderEnderBook;
import com.lothrazar.cyclic.item.enderbook.ScreenEnderBook;
import com.lothrazar.cyclic.registry.ContainerScreenRegistry;
import com.lothrazar.cyclic.util.UtilChat;
import com.lothrazar.cyclic.util.UtilEntity;
import com.lothrazar.cyclic.util.UtilItemStack;
import com.lothrazar.cyclic.util.UtilWorld;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.network.NetworkHooks;

public class EnderBookItem
extends ItemBaseCyclic {
    private static final String ITEMCOUNT = "itemCount";
    private static final int TP_COUNTDOWN = 60;
    private static final String ENDERSLOT = "enderslot";
    private static final String TELEPORT_COUNTDOWN = "TeleportCountdown";

    public EnderBookItem(Item.Properties properties) {
        super(properties);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        CompoundTag stackTag;
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        if (stack.m_41782_() && (stackTag = stack.m_41784_()).m_128441_(ITEMCOUNT)) {
            int itemCount = stackTag.m_128451_(ITEMCOUNT);
            TranslatableComponent t = new TranslatableComponent("cyclic.screen.filter.item.count");
            t.m_130946_("" + itemCount);
            t.m_130940_(ChatFormatting.GRAY);
            tooltip.add((Component)t);
        }
    }

    public boolean m_5812_(ItemStack stack) {
        if (stack.m_41782_() && stack.m_41783_().m_128441_(TELEPORT_COUNTDOWN)) {
            return true;
        }
        return super.m_5812_(stack);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        int enderslot;
        BlockPosDim loc;
        ItemStack stack;
        if (!worldIn.f_46443_ && !playerIn.m_6047_()) {
            NetworkHooks.openGui((ServerPlayer)((ServerPlayer)playerIn), (MenuProvider)new ContainerProviderEnderBook(), (BlockPos)playerIn.m_142538_());
        }
        if (!worldIn.f_46443_ && playerIn.m_6047_() && (stack = playerIn.m_21120_(handIn)).m_41773_() < stack.m_41776_() - 1 && (loc = EnderBookItem.getLocation(stack, enderslot = stack.m_41783_().m_128451_(ENDERSLOT))) != null) {
            UtilChat.addServerChatMessage(playerIn, new TranslatableComponent("item.cyclic.ender_book.start").m_130946_(loc.toString()));
            stack.m_41784_().m_128405_(TELEPORT_COUNTDOWN, 60);
        }
        return super.m_7203_(worldIn, playerIn, handIn);
    }

    public void m_6883_(ItemStack stack, Level worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (stack.m_41782_() && stack.m_41783_().m_128441_(TELEPORT_COUNTDOWN) && entityIn instanceof LivingEntity) {
            int ct = stack.m_41784_().m_128451_(TELEPORT_COUNTDOWN);
            if (ct < 0) {
                EnderBookItem.cancelTeleport(stack);
                return;
            }
            if (ct == 0 && entityIn instanceof Player) {
                Player p = (Player)entityIn;
                EnderBookItem.cancelTeleport(stack);
                int enderslot = stack.m_41783_().m_128451_(ENDERSLOT);
                BlockPosDim loc = EnderBookItem.getLocation(stack, enderslot);
                if (loc != null && loc.getPos() != null) {
                    if (loc.getDimension().equalsIgnoreCase(UtilWorld.dimensionToString(worldIn))) {
                        UtilEntity.enderTeleportEvent((LivingEntity)p, worldIn, loc.getPos());
                    } else {
                        UtilEntity.dimensionTeleport((ServerPlayer)p, (ServerLevel)worldIn, loc);
                    }
                    UtilItemStack.damageItem((LivingEntity)p, stack);
                    return;
                }
            } else if (ct % 20 == 0 && entityIn instanceof Player) {
                UtilChat.sendStatusMessage((Player)entityIn, (Component)new TranslatableComponent("item.cyclic.ender_book.countdown").m_130946_("" + ct / 20));
            }
            stack.m_41784_().m_128405_(TELEPORT_COUNTDOWN, --ct);
        }
    }

    public boolean m_6832_(ItemStack toRepair, ItemStack repair) {
        return repair.m_41720_() == Items.f_42584_;
    }

    public boolean isRepairable(ItemStack stack) {
        return true;
    }

    public static void cancelTeleport(ItemStack stack) {
        stack.m_41784_().m_128473_(TELEPORT_COUNTDOWN);
    }

    private static BlockPosDim getLocation(ItemStack stack, int enderSlot) {
        IItemHandler cap = (IItemHandler)stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).orElse(null);
        if (cap != null) {
            return LocationGpsCard.getPosition(cap.getStackInSlot(enderSlot));
        }
        return null;
    }

    @Override
    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundTag nbt) {
        return new CapabilityProviderEnderBook();
    }

    @Override
    public void registerClient() {
        MenuScreens.m_96206_(ContainerScreenRegistry.ENDER_BOOK, ScreenEnderBook::new);
    }

    @Override
    public CompoundTag getShareTag(ItemStack stack) {
        CompoundTag nbt = stack.m_41784_();
        IItemHandler cap = (IItemHandler)stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).orElse(null);
        if (cap != null) {
            int count = 0;
            for (int i = 0; i < cap.getSlots(); ++i) {
                if (cap.getStackInSlot(i).m_41619_()) continue;
                ++count;
            }
            nbt.m_128405_(ITEMCOUNT, count);
        }
        return nbt;
    }

    @Override
    public void readShareTag(ItemStack stack, CompoundTag nbt) {
        if (nbt != null) {
            CompoundTag stackTag = stack.m_41784_();
            stackTag.m_128405_(ITEMCOUNT, nbt.m_128451_(ITEMCOUNT));
        }
        super.readShareTag(stack, nbt);
    }

    public static void scroll(ServerPlayer player, int slot, boolean isDown) {
        ItemStack book = player.m_150109_().m_8020_(slot);
        if (book.m_41782_()) {
            int enderslot = book.m_41783_().m_128451_(ENDERSLOT);
            enderslot = EnderBookItem.scrollSlot(isDown, enderslot);
            book.m_41783_().m_128405_(ENDERSLOT, enderslot % 9);
            BlockPosDim loc = EnderBookItem.getLocation(book, enderslot);
            String msg = "---";
            if (loc != null) {
                msg = loc.getDisplayString();
            }
            UtilChat.addServerChatMessage((Player)player, new TextComponent(book.m_41783_().m_128451_(ENDERSLOT) + " : ").m_130946_(msg));
        }
    }

    private static int scrollSlot(boolean isDown, int enderslot) {
        if ((enderslot += isDown ? -1 : 1) < 0) {
            enderslot = 8;
        } else if (enderslot >= 9) {
            enderslot = 0;
        }
        return enderslot;
    }
}

